// XISLOutputAgent.cpp: CXISLOutputAgent NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLOutputAgent.h"
#include "XISLVar.h"
#include "XISLExcItem.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CXISLOutputAgent::CXISLOutputAgent(int nAgentType)
{
	m_nTagType = ID_TAG_OUTPUT;
	m_nBmpID = IDB_AGENT;
	m_nOutputType = ID_OUTPUTTYPE_AGENT;

	m_pParentTag = NULL;
	m_pTextList = NULL;
	m_nNameID = nAgentType;
}

CXISLOutputAgent::~CXISLOutputAgent()
{
	if(m_pTextList)
	{
		InitTextList();
		delete m_pTextList;
	}
}

CXISLOutputAgent::CXISLOutputAgent(const CXISLOutputAgent &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_nOutputEvent = cpXISL.m_nOutputEvent;
	m_nOutputType = cpXISL.m_nOutputType;

	m_nNameID = cpXISL.m_nNameID;
	m_nParam[0] = cpXISL.m_nParam[0];
	m_nParam[1] = cpXISL.m_nParam[1];
	m_strParam = cpXISL.m_strParam;
/*
	m_nCharacter = cpXISL.m_nCharacter;
	m_nAgentPosition = cpXISL.m_nAgentPosition;
	m_nAgentSChar = cpXISL.m_nAgentSChar;
	m_nX = cpXISL.m_nX;
	m_nY = cpXISL.m_nY;
	m_strAgentParam = cpXISL.m_strAgentParam;
	m_strAgentObj = cpXISL.m_strAgentObj;
*/
}

CXISLOutputAgent& CXISLOutputAgent::operator=(const CXISLOutputAgent &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_nOutputEvent = cpXISL.m_nOutputEvent;
		m_nOutputType = cpXISL.m_nOutputType;

		m_nNameID = cpXISL.m_nNameID;
		m_nParam[0] = cpXISL.m_nParam[0];
		m_nParam[1] = cpXISL.m_nParam[1];
		m_strParam = cpXISL.m_strParam;
/*
		m_nCharacter = cpXISL.m_nCharacter;
		m_nAgentPosition = cpXISL.m_nAgentPosition;
		m_nAgentSChar = cpXISL.m_nAgentSChar;
		m_nX = cpXISL.m_nX;
		m_nY = cpXISL.m_nY;
		m_strAgentParam = cpXISL.m_strAgentParam;
		m_strAgentObj = cpXISL.m_strAgentObj;
*/
	}
	return *this;
}

//void CXISLOutputAgent::GetDrawString(CString &strText)
//@\@F\peLXg擾
//@FCString :i[p
//ԂlFvoid
void CXISLOutputAgent::GetDrawString(CString &strText)
{
	switch(m_nOutputEvent)
	{
	case ID_AGENTEVENT_CREATE:
		strText = "";
		break;
	case ID_AGENTEVENT_MOVEXY:
		strText.Format("ړ:(%d,%d)",m_nParam[0],m_nParam[1]);
		break;
	case ID_AGENTEVENT_MOVEOBJ:
		strText = "ړ:";
		strText += m_strParam;
		break;
	case ID_AGENTEVENT_SCHAR:
		strText = "ύX:";
		strText += SPEECH_CHARACTOR[m_nParam[0]];
		break;
	case ID_AGENTEVENT_ACTION:
		strText = "ANV:";
		strText += m_strParam;
		break;
	case ID_AGENTEVENT_SPEECH:
		GetText(strText);
		strText.Insert(0,"speech:\n");
		break;
	case ID_AGENTEVENT_BALLOON:
		GetText(strText);
		strText.Insert(0,"balloon:\n");
		break;
	}
}

//LPCTSTR CXISLOutputAgent::GetXISLString()
//@\@FactionȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLOutputAgent::GetXISLString()
{
	CString strOutputType = XISL_OUTPUT_TYPE[m_nOutputType];
	CString strOutputEvent = XISL_OUTPUT_EVENT[m_nOutputEvent];

	m_strXISL = "<output type=\"" + strOutputType;
	m_strXISL += "\" event=\"";
	m_strXISL += strOutputEvent;
	m_strXISL += "\">\r\n";
	m_strXISL += "<![CDATA[\r\n";
	m_strXISL += "<param name=\"name\">";
	m_strXISL += AGENT_NAME[m_nNameID];
	m_strXISL += "</param>\r\n";

	char cPoint[10];
	CString strText;
	switch(m_nOutputEvent)
	{
	case ID_AGENTEVENT_CREATE:
	case ID_AGENTEVENT_DESTROY:
	case ID_AGENTEVENT_SHOW:
	case ID_AGENTEVENT_HIDE:
		break;
	case ID_AGENTEVENT_MOVEXY:
		m_strXISL += "<param name=\"x\">";
		m_strXISL += itoa(m_nParam[0],cPoint,10);
		m_strXISL += "</param>\r\n<param name=\"y\">";
		m_strXISL += itoa(m_nParam[1],cPoint,10);
		m_strXISL += "</param>\r\n";
		break;
	case ID_AGENTEVENT_MOVEOBJ:
		m_strXISL += "<param name=\"object\">";
		m_strXISL += m_strParam;
		m_strXISL += "</param>\r\n<param name=\"position\">";
		m_strXISL += MOVE_POSITION[m_nParam[0]];
		m_strXISL += "</param>\r\n";
		break;
	case ID_AGENTEVENT_SCHAR:
		m_strXISL += "<param name=\"character\">";
		m_strXISL += SPEECH_CHARACTOR[m_nParam[0]];
		m_strXISL += "</param>\r\n";
		break;
	case ID_AGENTEVENT_ACTION:
		m_strXISL += "<param name=\"action\">";
		m_strXISL += m_strParam;
		m_strXISL += "</param>\r\n";
		break;
	case ID_AGENTEVENT_SPEECH:
	case ID_AGENTEVENT_BALLOON:
		m_strXISL += "<param name=\"text\">";
		GetText(strText);
		m_strXISL += strText;
		m_strXISL += "</param>\r\n";
		break;
	}

	m_strXISL += "]]>\r\n</output>\r\n";

	return m_strXISL;
}


//BOOL CXISLOutputAgent::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLOutputAgent::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_OUTPUT];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	return TRUE;
}

void CXISLOutputAgent::GetMovePoint(int *npPoint)
{
	if(m_nOutputEvent == ID_AGENTEVENT_MOVEXY)
	{
		npPoint[0] = m_nParam[0];
		npPoint[1] = m_nParam[1];
		return;
	}
	else
		ASSERT(NULL);
}

int CXISLOutputAgent::GetMoveObj(CString &strParam)
{
	if(m_nOutputEvent == ID_AGENTEVENT_MOVEOBJ)
	{
		strParam = m_strParam;
		return m_nParam[0];
	}
	else
		ASSERT(NULL);
	return 0;
}

int CXISLOutputAgent::GetCharactor()
{
	if(m_nOutputEvent == ID_AGENTEVENT_SCHAR)
		return m_nParam[0];

	ASSERT(NULL);
	return 0;
}

LPCTSTR CXISLOutputAgent::GetText(CString &strText)
{
	if(m_nOutputEvent != ID_AGENTEVENT_SPEECH
		&& m_nOutputEvent != ID_AGENTEVENT_BALLOON)
		ASSERT(NULL);

	m_strParam.Empty();
	strText.Empty();
	CString strVarName;
	POSITION pos = m_pTextList->GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_pTextList->GetNext(pos);
		if(pVar->IsDummy())
		{
			m_strParam += pVar->GetVarName();
			strText += pVar->GetVarName();
		}
		else
		{
			m_strParam += " $";
			m_strParam += pVar->GetVarName();
			m_strParam += " ";

			pVar->GetVarNameEx(strVarName);
			strText += "<value expr=\"";
			strText += strVarName;
			strText += "\"/>";
		}
	}

	return m_strParam;
}

LPCTSTR CXISLOutputAgent::GetActionName()
{
	if(m_nOutputEvent == ID_AGENTEVENT_ACTION)
		return m_strParam;

	ASSERT(NULL);
	return "";
}

BOOL CXISLOutputAgent::SetAttribute(int nEvent,LPCTSTR lpszParam,int nParam1,int nParam2)
{
	m_nOutputEvent = nEvent;
	InitTextList();
	if(m_pTextList && (m_nOutputEvent != ID_AGENTEVENT_SPEECH && m_nOutputEvent != ID_AGENTEVENT_BALLOON))
	{
		delete m_pTextList;
		m_pTextList = NULL;
	}
	switch(m_nOutputEvent)
	{
	case ID_AGENTEVENT_CREATE:
	case ID_AGENTEVENT_DESTROY:
	case ID_AGENTEVENT_SHOW:
	case ID_AGENTEVENT_HIDE:
		break;
	case ID_AGENTEVENT_MOVEXY:
		m_nParam[0] = nParam1;
		m_nParam[1] = nParam2;
		break;
	case ID_AGENTEVENT_MOVEOBJ:
		m_nParam[0] = nParam1;
		m_strParam = lpszParam;
		break;
	case ID_AGENTEVENT_SCHAR:
		m_nParam[0] = nParam1;
		break;
	case ID_AGENTEVENT_ACTION:
		m_strParam = lpszParam;
		break;
	case ID_AGENTEVENT_SPEECH:
	case ID_AGENTEVENT_BALLOON:
		if(m_pTextList == NULL)
			m_pTextList = new CPtrList;
		break;
	}
	return TRUE;
}

BOOL CXISLOutputAgent::SetAttribute(LPCTSTR lpszEvent,LPCTSTR lpszParam)
{
	int nEvent=ID_AGENTEVENT_CREATE;
	while(1)
	{
		if(strcmp(lpszEvent,XISL_OUTPUT_EVENT[nEvent]) == 0)
			break;

		if(nEvent>ID_AGENTEVENT_BALLOON)
		{
			AfxMessageBox("`ĂȂeventł",MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
			return FALSE;
		}
		nEvent++;
	}

	m_nOutputEvent = nEvent;

	CString strParam = lpszParam;
	CString strParamName;
	CString strValue;
	int nFlag=0;//0 or 1 or 2:<param>Ȃ, 3:OK
	int nIndex=0,nStart=0,nEnd=0;
	while(1)
	{
		nIndex = strParam.Find("<param",nIndex);
		if(nIndex==-1)
			return FALSE;

		nIndex = strParam.Find("name",nIndex);
		nStart = strParam.Find("\"",nIndex);
		nStart++;
		nEnd = strParam.Find("\"",nStart);
		strParamName = strParam.Mid(nStart,nEnd-nStart);

		nStart = strParam.Find(">",nEnd);
		nStart++;
		nEnd = strParam.Find("</",nStart);
		strValue = strParam.Mid(nStart,nEnd-nStart);
		nIndex = nEnd + 1;

		if(strParamName.Compare("name")==0)
		{
			if(strValue.Compare(AGENT_NAME[ID_AGENT_MERLIN])==0)
				m_nNameID = ID_AGENT_MERLIN;
			else if(strValue.Compare(AGENT_NAME[ID_AGENT_ROBBY])==0)
				m_nNameID = ID_AGENT_ROBBY;
			else
				return FALSE;
			if(m_nOutputEvent == ID_AGENTEVENT_CREATE || m_nOutputEvent == ID_AGENTEVENT_SHOW
				|| m_nOutputEvent == ID_AGENTEVENT_DESTROY || m_nOutputEvent == ID_AGENTEVENT_HIDE)
				nFlag=3;
			else
				nFlag++;
		}
		else if(strParamName.Compare("action")==0)
		{
			if(m_nOutputEvent != ID_AGENTEVENT_ACTION)
				return FALSE;
			m_strParam = strValue;
			nFlag+=2;
		}
		else if(strParamName.Compare("voice")==0)
		{
			if(m_nOutputEvent != ID_AGENTEVENT_SCHAR)
				return FALSE;
			for(int nChar=SCHAR_BROTHER;nChar<=SCHAR_ROBOC;nChar++)
			{
				if(strcmp(SPEECH_CHARACTOR[nChar],strValue) == 0)
					break;
			}
			m_nParam[0] = nChar;
			nFlag+=2;
		}
		else if(strParamName.Compare("text")==0)
		{
			if(m_nOutputEvent != ID_AGENTEVENT_SPEECH
				&& m_nOutputEvent != ID_AGENTEVENT_BALLOON)
				return FALSE;
			m_strParam = strValue;
			if(!SetText(m_strParam))
				return FALSE;
			nFlag+=2;
		}
		else if(strParamName.Compare("x")==0)
		{
			if(m_nOutputEvent != ID_AGENTEVENT_MOVEXY)
				return FALSE;
			m_nParam[0] = atoi(strValue);
			nFlag++;
		}
		else if(strParamName.Compare("y")==0)
		{
			if(m_nOutputEvent != ID_AGENTEVENT_MOVEXY)
				return FALSE;
			m_nParam[1] = atoi(strValue);
			nFlag++;
		}
		else if(strParamName.Compare("object")==0)
		{
			if(m_nOutputEvent != ID_AGENTEVENT_MOVEOBJ)
				return FALSE;
			m_strParam = strValue;
			nFlag++;
		}
		else if(strParamName.Compare("position")==0)
		{
			if(m_nOutputEvent != ID_AGENTEVENT_MOVEOBJ)
				return FALSE;

			if(strValue.Compare("left")==0)
				m_nParam[0] = POSITION_LEFT;
			else if(strValue.Compare("center")==0)
				m_nParam[0] = POSITION_CENTER;
			else if(strValue.Compare("right")==0)
				m_nParam[0] = POSITION_RIGHT;
			nFlag++;
		}
		if(nFlag==3)
			break;
	}
	return TRUE;
}

BOOL CXISLOutputAgent::SetText(CPtrList *pTextList)
{
	ASSERT(m_pTextList);

	POSITION pos = pTextList->GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)pTextList->GetNext(pos);
		m_pTextList->AddTail(pVar);
		pVar->ReferCount(TRUE);
	}
	return TRUE;
}

BOOL CXISLOutputAgent::SetText(LPCTSTR lpszTextList)
{
	if(m_pTextList==NULL)
		m_pTextList = new CPtrList;

	CString strText = lpszTextList;
	int nStart=0;
	CXISLVar *pText=NULL;
	CString strVarName;
	BOOL bOK = TRUE;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
	while(1)
	{
		if(strText.IsEmpty())
			break;
		nStart = strText.Find("<value",0);

		if(nStart == -1)
		{
			pText = new CXISLVar;
			pText->SetAttribute(strText,"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			break;
		}
		if(nStart != 0)
		{
			pText = new CXISLVar;
			pText->SetAttribute(strText.Left(nStart),"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			strText.Delete(0,nStart);
		}
		else
		{
			nStart = strText.Find("/>");
			if(nStart == -1)
			{
				AfxMessageBox("<value>̕^O܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			strVarName = strText.Left(nStart);
			int nIndex = strVarName.Find("expr",0);
			if(nIndex == -1)
			{
				AfxMessageBox("<value>expr܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			
			nIndex = strVarName.Find("\"",nIndex);
			int nEnd = strVarName.ReverseFind('"');
			strVarName = strVarName.Mid(nIndex+1,nEnd-nIndex-1);
			CXISLVar *pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
			if(pVar == NULL)
			{
				AfxMessageBox("݂Ȃϐw肳܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			strText.Delete(0,nStart+2);
			m_pTextList->AddTail(pVar);
			pVar->ReferCount(TRUE);
		}
	}

	if(!bOK)
		InitTextList();

	return bOK;
}

void CXISLOutputAgent::InitTextList()
{
	if(m_pTextList == NULL)
		return;

	//_~[CXISLVar͍폜
	while(!m_pTextList->IsEmpty())
	{
		CXISLVar *pVar = (CXISLVar*)m_pTextList->RemoveHead();
		if(pVar->IsDummy())
			delete pVar;
		else
			pVar->ReferCount(FALSE);
	}
}

/*
//create,destroy,show,hide
CXISLOutputAgent::CXISLOutputAgent(CXISLTag *pParent,int nType,int nEvent,int nChar)
{
	m_pParentTag = pParent;
	m_nTagType = ID_TAG_OUTPUT;
	m_nBmpID = IDB_AGENT;
	m_nOutputType = nType;
	m_nOutputEvent = nEvent;
	m_nCharacter = nChar;
}

//move1
CXISLOutputAgent::CXISLOutputAgent(CXISLTag *pParent,int nType,int nEvent,int nChar,int nX,int nY)
{
	m_pParentTag = pParent;
	m_nTagType = ID_TAG_OUTPUT;
	m_nBmpID = IDB_AGENT;
	m_nOutputType = nType;
	m_nOutputEvent = nEvent;
	m_nCharacter = nChar;

	m_nX = nX;
	m_nY = nY;
}

//move2
CXISLOutputAgent::CXISLOutputAgent(CXISLTag *pParent,int nType,int nEvent,int nChar,LPCTSTR lpszObject,int nPosition)
{
	m_pParentTag = pParent;
	m_nTagType = ID_TAG_OUTPUT;
	m_nBmpID = IDB_AGENT;
	m_nOutputType = nType;
	m_nOutputEvent = nEvent;
	m_nCharacter = nChar;

	m_strAgentObj = lpszObject;
	m_nAgentPosition = nPosition;
}

//speech-character
CXISLOutputAgent::CXISLOutputAgent(CXISLTag *pParent,int nType,int nEvent,int nChar,int nSChar)
{
	m_pParentTag = pParent;
	m_nTagType = ID_TAG_OUTPUT;
	m_nBmpID = IDB_AGENT;
	m_nOutputType = nType;
	m_nOutputEvent = nEvent;
	m_nCharacter = nChar;

	m_nAgentSChar = nSChar;
}

//agent-action,agent-speech,agent-ballon
CXISLOutputAgent::CXISLOutputAgent(CXISLTag *pParent,int nType,int nEvent,int nChar,LPCTSTR lpszAgentParam)
{
	m_pParentTag = pParent;
	m_nTagType = ID_TAG_OUTPUT;
	m_nBmpID = IDB_AGENT;
	m_nOutputType = nType;
	m_nOutputEvent = nEvent;
	m_nCharacter = nChar;

	m_strAgentParam = lpszAgentParam;
}
*/
